#pragma once

#include "Mix/Private/Graphics/Common/DeviceObject.h"
#include "Mix/Graphics/IShaderConstant.h"

namespace Mix{ namespace Graphics{ namespace DX11{

	class Device;

	class ShaderConstant : public Mix::Graphics::IShaderConstant, public Mix::Graphics::Common::DeviceObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX11::ShaderConstant
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		static ShaderConstant* CreateInstance( Mix::Graphics::DX11::Device* pDevice, UInt32 size, Boolean bDynamic, ID3D11Buffer* pBuffer );

	private:
		Mix::Graphics::DX11::Device* m_pDevice;
		UInt32 m_Size;
		Boolean m_bDynamic;
		ID3D11Buffer* m_pBuffer;
		D3D11_MAPPED_SUBRESOURCE m_Mapped;
		Boolean m_bLock;

	private:
		ShaderConstant( Mix::Graphics::DX11::Device* pDevice, UInt32 size, Boolean bDynamic, ID3D11Buffer* pBuffer );
		virtual ~ShaderConstant( void );

	public:
		ID3D11Buffer* GetInterface( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IShaderConstant
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Boolean Lock( void );
		virtual void Unlock( void );
		virtual Boolean Write( const void* pData, UInt32 dataSize );
		virtual UInt32 GetSize( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IDeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::IDeviceObject::TYPE GetType( void ) const;
	};

}}}
