#pragma once

#include "Mix/Private/Graphics/Common/DeviceObject.h"
#include "Mix/Graphics/IHullShader.h"

namespace Mix{ namespace Graphics{ namespace DX11{

	class Device;

	class HullShader : public Mix::Graphics::IHullShader, public Mix::Graphics::Common::DeviceObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX11::HullShader
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		static HullShader* CreateInstance( Mix::Graphics::DX11::Device* pDevice, ID3D11HullShader* pHullShader );

	private:
		ID3D11HullShader* m_pHullShader;

	private:
		HullShader( Mix::Graphics::DX11::Device* pDevice, ID3D11HullShader* pHullShader );
		virtual ~HullShader( void );

	public:
		ID3D11HullShader* GetInterface( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IDeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::IDeviceObject::TYPE GetType( void ) const;
	};

}}}
