#include "Mix/Private/Graphics/DX11/HullShader.h"
#include "Mix/Private/Graphics/DX11/Device.h"

namespace Mix{ namespace Graphics{ namespace DX11{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX11::HullShader
////////////////////////////////////////////////////////////////////////////////////////////////////

HullShader* HullShader::CreateInstance( Mix::Graphics::DX11::Device* pDevice, ID3D11HullShader* pHullShader )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GRAPHICS, HullShader, pDevice, pHullShader );
}

HullShader::HullShader( Mix::Graphics::DX11::Device* pDevice, ID3D11HullShader* pHullShader ) :
DeviceObject( pDevice ),
m_pHullShader( pHullShader )
{
}

HullShader::~HullShader( void )
{
	MIX_RELEASE( m_pHullShader );
}

ID3D11HullShader* HullShader::GetInterface( void )
{
	return m_pHullShader;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::IDeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::IDeviceObject::TYPE HullShader::GetType( void ) const
{
	return Mix::Graphics::IDeviceObject::HULL_SHADER;
}

}}}
