#include "Mix/Private/Graphics/DX11/DomainShader.h"
#include "Mix/Private/Graphics/DX11/Device.h"

namespace Mix{ namespace Graphics{ namespace DX11{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Class::Graphics::DomainShader
////////////////////////////////////////////////////////////////////////////////////////////////////

DomainShader* DomainShader::CreateInstance( Mix::Graphics::DX11::Device* pDevice, ID3D11DomainShader* pDomainShader )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GRAPHICS, DomainShader, pDevice, pDomainShader );
}

DomainShader::DomainShader( Mix::Graphics::DX11::Device* pDevice, ID3D11DomainShader* pDomainShader ) :
DeviceObject( pDevice ),
m_pDomainShader( pDomainShader )
{
}

DomainShader::~DomainShader( void )
{
	MIX_RELEASE( m_pDomainShader );
}

ID3D11DomainShader* DomainShader::GetInterface( void )
{
	return m_pDomainShader;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::IDeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::IDeviceObject::TYPE DomainShader::GetType( void ) const
{
	return Mix::Graphics::IDeviceObject::DOMAIN_SHADER;
}

}}}
