#include "Mix/Private/Graphics/Common/DeviceObject.h"
#include "Mix/Private/Graphics/Common/Device.h"

namespace Mix{ namespace Graphics{ namespace Common{

DeviceObject::DeviceObject( Mix::Graphics::Common::Device* pDevice ) :
m_pDevice( NULL )
{
	MIX_ASSERT( pDevice != NULL );

#ifdef _DEBUG
	m_DebugName = MIX_SAFE_NAME( NULL );
#endif //_DEBUG

	MIX_ADD_REF( pDevice );
	m_pDevice = pDevice;

	m_pDevice->AddDeviceObject( this );
}

DeviceObject::~DeviceObject( void )
{
	if( m_pDevice != NULL )
	{
		m_pDevice->RemoveDeviceObject( this );
	}

	MIX_RELEASE( m_pDevice );
}

#ifdef _DEBUG

const wchar_t* DeviceObject::GetDebugName( void ) const
{
	return m_DebugName.GetConstPtr();
}

void DeviceObject::SetDebugName( const wchar_t* pDebugName )
{
	m_DebugName = pDebugName;
}

#endif //_DEBUG

}}}
