#pragma once

#include "Mix/Dynamics/IConeShape.h"
#include "Mix/Private/Dynamics/Shape.h"

namespace Mix{ namespace Dynamics{

	class ConeShape : public Mix::Dynamics::IConeShape, public Mix::Dynamics::Shape
	{
	public:
		static ConeShape* CreateInstance( void );

	private:
		Mix::Dynamics::AXIS_TYPE m_Axis;
		btConeShape* m_pObject;

	private:
		ConeShape( void );
		virtual ~ConeShape( void );

	public:
		Boolean Initialize( Mix::Dynamics::AXIS_TYPE axis, Float32 axisLength, Float32 radius );

	public:
		virtual btConvexShape* Bullet_GetConvexShapePtr( void ) const;

	public:
		virtual Float32 GetAxisLength( void ) const;
		virtual Float32 GetRadius( void ) const;

	public:
		virtual Mix::Dynamics::IShape::TYPE GetType( void ) const;

		virtual Float32 GetMargin( void ) const;
		virtual void SetMargin( Float32 margin );

		virtual void DebugDraw( Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer );
	};

}}
