#include "Mix/Private/Dynamics/ConeShape.h"

#include "Mix/Graphics/Utility/IPerspectiveRenderer.h"

namespace Mix{ namespace Dynamics{

ConeShape* ConeShape::CreateInstance( void )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_DYNAMICS, ConeShape );
}

ConeShape::ConeShape( void ) :
m_Axis( Mix::Dynamics::AXIS_Y ),
m_pObject( NULL )
{
}

ConeShape::~ConeShape( void )
{
	MIX_LIB_DELETE( m_pObject );
}

Boolean ConeShape::Initialize( Mix::Dynamics::AXIS_TYPE axis, Float32 axisLength, Float32 radius )
{
	switch( axis )
	{
	case Mix::Dynamics::AXIS_X:
		m_pObject = MIX_LIB_NEW btConeShapeX( radius, axisLength );
		break;
	case Mix::Dynamics::AXIS_Y:
		m_pObject = MIX_LIB_NEW btConeShape( radius, axisLength );
		break;
	case Mix::Dynamics::AXIS_Z:
		m_pObject = MIX_LIB_NEW btConeShapeZ( radius, axisLength );
		break;
	}

	if( m_pObject == NULL )
	{
		return False;
	}

	Shape::Bullet_SetCollisionShape( m_pObject );
	m_Axis = axis;

	return True;
}

btConvexShape* ConeShape::Bullet_GetConvexShapePtr( void ) const
{
	return m_pObject;
}

Float32 ConeShape::GetAxisLength( void ) const
{
	return m_pObject->getHeight();
}

Float32 ConeShape::GetRadius( void ) const
{
	return m_pObject->getRadius();
}

Mix::Dynamics::IShape::TYPE ConeShape::GetType( void ) const
{
	return Mix::Dynamics::IShape::CONE;
}

Float32 ConeShape::GetMargin( void ) const
{
	return Shape::Bullet_GetMargin();
}
void ConeShape::SetMargin( Float32 margin )
{
	Shape::Bullet_SetMargin( margin );
}

void ConeShape::DebugDraw( Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer )
{
}

}}
