#include "Mix/Private/Dynamics/CapsuleShape.h"
#include "Mix/Graphics/Utility/IPerspectiveRenderer.h"

namespace Mix{ namespace Dynamics{

CapsuleShape* CapsuleShape::CreateInstance( void )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_DYNAMICS, CapsuleShape );
}

CapsuleShape::CapsuleShape( void ) :
m_pObject( NULL ),
m_Height( 0.0f )
{
}

CapsuleShape::~CapsuleShape( void )
{
	MIX_LIB_DELETE( m_pObject );
}

Boolean CapsuleShape::Initialize( Mix::Dynamics::AXIS_TYPE axis, Float32 height, Float32 radius )
{
	height = max( 0.0f, height - radius * 2.0f );

	switch( axis )
	{
	case Mix::Dynamics::AXIS_X:
		m_pObject = MIX_LIB_NEW btCapsuleShapeX( radius, height );
		break;
	case Mix::Dynamics::AXIS_Y:
		m_pObject = MIX_LIB_NEW btCapsuleShape( radius, height );
		break;
	case Mix::Dynamics::AXIS_Z:
		m_pObject = MIX_LIB_NEW btCapsuleShapeZ( radius, height );
		break;
	}

	if( m_pObject == NULL )
	{
		return False;
	}

	Shape::Bullet_SetCollisionShape( m_pObject );
	m_Axis = axis;
	m_Height = height + radius * 2.0f;

	return True;
}

btConvexShape* CapsuleShape::Bullet_GetConvexShapePtr( void ) const
{
	return m_pObject;
}

Mix::Dynamics::AXIS_TYPE CapsuleShape::GetAxis( void ) const
{
	return m_Axis;
}

Float32 CapsuleShape::GetHeight( void ) const
{
	return m_Height;
}

Float32 CapsuleShape::GetRadius( void ) const
{
	return m_pObject->getRadius();
}

Mix::Dynamics::IShape::TYPE CapsuleShape::GetType( void ) const
{
	return Mix::Dynamics::IShape::CAPSULE;
}

Float32 CapsuleShape::GetMargin( void ) const
{
	return Shape::Bullet_GetMargin();
}
void CapsuleShape::SetMargin( Float32 margin )
{
	Shape::Bullet_SetMargin( margin );
}

void CapsuleShape::DebugDraw( Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer )
{
	if( pPerspectiveRenderer != NULL )
	{
		pPerspectiveRenderer->AddCapsule( m_Axis, GetHeight(), GetRadius() );
	}
}

}}
