#include "Mix/Private/Dynamics/BoxShape.h"
#include "Mix/Graphics/Utility/IPerspectiveRenderer.h"

namespace Mix{ namespace Dynamics{

BoxShape* BoxShape::CreateInstance( const Mix::Vector3& size )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_DYNAMICS, BoxShape, size );
}

BoxShape::BoxShape( const Mix::Vector3& size ) :
m_Size( size ),
m_pObject( NULL )
{
}

BoxShape::~BoxShape( void )
{
	MIX_LIB_DELETE( m_pObject );
}

Boolean BoxShape::Initialize( void )
{
	m_pObject = MIX_LIB_NEW btBoxShape( btVector3( m_Size.x, m_Size.y, m_Size.z ) );
	if( m_pObject != NULL )
	{
		Shape::Bullet_SetCollisionShape( m_pObject );
	}
	else
	{
		return False;
	}

	return True;
}

btConvexShape* BoxShape::Bullet_GetConvexShapePtr( void ) const
{
	return m_pObject;
}

const Mix::Vector3& BoxShape::GetHalfExtents( void ) const
{
	return m_Size;
}

Mix::Dynamics::IShape::TYPE BoxShape::GetType( void ) const
{
	return Mix::Dynamics::IShape::BOX;
}

Float32 BoxShape::GetMargin( void ) const
{
	return Shape::Bullet_GetMargin();
}
void BoxShape::SetMargin( Float32 margin )
{
	Shape::Bullet_SetMargin( margin );
}

void BoxShape::DebugDraw( Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer )
{
	if( pPerspectiveRenderer != NULL )
	{
		pPerspectiveRenderer->AddBox( GetHalfExtents() );
	}
}

}}
