#pragma once

//! @file Mix/MultipleEvent.h
//! @brief CxgNXCN[ht@C

#include "Mix/Noncopyable.h"

namespace Mix{

	//! @class MultipleEvent
	//! @brief CxgNX
	class _MIX_DLL_API MultipleEvent : public Mix::Noncopyable
	{
	private:
		UInt32	m_EventCount;							///< Cxg
		HANDLE	m_hEventArray[MAXIMUM_WAIT_OBJECTS];	///< Cxgnhz

	public:
		//! @brief RXgN^
		//! @param[in] bSignal VOiԂŃCxg쐬ɂ TRUE
		//! @param[in] bManualReset 蓮ŃZbgꍇ True
		//! @param[in] count Cxg ( MAXIMUM_WAIT_OBJECTS ȉ )
		MultipleEvent( Boolean bSignal = False, Boolean bManualReset = False, UInt32 count = 1 );
		//! @brief fXgN^
		~MultipleEvent( void );

		//! @brief VOiԂɂ
		//! @param[in] index CxgCfbNX
		void Set( UInt32 index = 0 );
		//! @brief VOiԂɂ
		//! @param[in] index CxgCfbNX
		void Reset( UInt32 index = 0 );
		//! @brief ׂẴCxgVOiԂɂ
		void SetAll( void );
		//! @brief ׂẴCxgVOiԂɂ
		void ResetAll( void );

		//! @brief VOiԂɂȂ܂őҋ@
		//! @param[in] index CxgCfbNX
		//! @param[in] timeOut ^CAEg( 1000ms P )<br>
		//! INFINITE ɑ҂
		//! @retval TRUE VOi
		//! @retval FALSE VOi
		Boolean Wait( UInt32 index = 0, UInt32 timeOut = INFINITE );

		//! @brief SẴCxgVOiԂɂȂ܂őҋ@
		//! @param[in] bAll ׂẴCxgVOiԂɂȂ܂őҋ@ꍇ TRUE
		//! @param[in] timeOut ^CAEg\n
		//! INFINITE Ŗɑҋ@
		//! @return VOiԂɂȂCxg̃CfbNX
		//! @retval 0xFFFFFFFF VOiԂɂȂCxg͖
		UInt32 WaitAll( Boolean bAll = FALSE, UInt32 timeOut = INFINITE );

		//! @brief nh擾܂
		//! @param[in] index 擾nh̃CfbNX
		//! @return nhԂ܂
		HANDLE GetHandle( UInt32 index ) const;
	};

}
