#pragma once

//! @file Mix/IO/IReader.h
//! @brief [_[C^[tF[XCN[ht@C

#include "Mix/IO/IStream.h"

namespace Mix{ namespace IO{

	//! @class IReader
	//! @brief [_[C^[tF[X
	//! @note
	//! [_[ɂ̓t@C𒼐ڑ삷ut@C[_[vƁÃt@C𑀍삷uobt@h[_[v܂B<br>
	//! O҂̓t@C𒼐ڑ삷邽߁A͏ȂłA[_[(t@C)܂ŁAVɃ[_[쐬邱Ƃł܂B<br>
	//! ҂̓̃t@C𑀍삷邽߁A͑łÃ[_[쐬邱ƂłA܂邱Ƃł܂B<br>
	//! ̓t@Ci[Ă郁L邽߁AKvȏɃ邱Ƃ͂܂B
	class IReader : public Mix::IO::IStream
	{
	protected:
		//! @brief fXgN^
		virtual ~IReader( void ){}

	public:
		//! @brief ݂̈ʒuw肳ꂽobt@ɓǂݍ݂܂
		//! @param[in] pReadBuffer ǂݍݐobt@
		//! @param[in] readSize ǂݍރTCY
		//! @return ۂɓǂݍ񂾃TCYԂ܂
		virtual UInt32 Read( void* pReadBuffer, UInt32 readSize ) = 0;
		//! @brief w肳ꂽʒuɃV[N܂
		//! @param[in] seekMethod V[N\ Mix::IO::SEEK_METHOD 񋓒萔
		//! @param[in] offset ItZbg
		//! @return V[N̈ʒuԂ܂
		virtual UInt64 Seek( Mix::IO::SEEK_METHOD seekMethod, Int64 offset ) = 0;
		//! @brief ݂̈ʒu擾܂
		//! @return ݂̈ʒuԂ܂
		virtual UInt64 GetPos( void ) const = 0;
		//! @brief TCY擾܂
		//! @return TCYԂ܂
		virtual UInt64 GetSize( void ) const = 0;
		//! @brief t@CpX擾܂
		//! @return t@CpXԂ܂
		virtual const wchar_t* GetFilePath( void ) const = 0;

		//! @brief N[쐬܂
		//! @param[out] ppClone 쐬N[n Mix::IO::IReader C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note N[쐬ł̂́AANZX^Cv A_READA\[X^Cv S_BUFFER Ɍ肳܂B
		virtual Boolean Clone( Mix::IO::IReader** ppClone ) = 0;
	};

}}
