#pragma once

//! @file Mix/IO/IManager.h
//! @brief t@C}l[WC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace IO{

	//! @class IManager
	//! @brief IO }l[WC^[tF[X
	//! @note
	//! ut@CvufBNgvւ̃ANZX̓}Egʂčs܂B<br>
	//! }EgĂȂfBNgAt@Cւ̃ANZX͂łȂ悤ɂȂĂ܂B<br>
	class IManager : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IManager( void ){}

	public:
		//! @brief [gfBNg̃pX擾܂
		//! @return [gfBNg̃pXԂ܂
		virtual const wchar_t* GetRootDirectoryPath( void ) const = 0;
		//! @brief [U[fBNg̃pX擾܂
		//! @return [U[fBNg̃pXԂ܂
		virtual const wchar_t* GetUserDirectoryPath( void ) const = 0;

		//! @brief w肵A[JCũt@Cgpł悤ɂ܂
		//! @param[in] pFilePath A[JCũt@CpX
		//! @return ꍇ True Ԃ܂
		virtual Boolean MountArchive( const wchar_t* pFilePath ) = 0;
		//! @brief w肵fBNg̃t@Cgpł悤ɂ܂
		//! @param[in] pDirectoryPath fBNgpX
		//! @return ꍇ True Ԃ܂
		virtual Boolean MountDirectory( const wchar_t* pDirectoryPath ) = 0;
		//! @brief w肵t@Cgpł悤ɂ܂
		//! @param[in] pFilePath t@CpX
		//! @return ꍇ True Ԃ܂
		virtual Boolean MountFile( const wchar_t* pFilePath ) = 0;

		//! @brief w肵t@C̗LmF܂
		//! @param[in] pFilePath t@CpX
		//! @return ݂Ăꍇ True Ԃ܂
		//! @note w肳ꂽt@C}EgĂȂꍇ͂ł False Ԃ܂B
		virtual Boolean ExistsFile( const wchar_t* pFilePath ) = 0;

		//! @brief t@Cobt@쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[out] ppBuffer 쐬t@Cobt@n Mix::Memory::IBuffer C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateBufferFromFile( const wchar_t* pFilePath, Mix::Memory::IBuffer** ppBuffer ) = 0;

		//! @brief t@C[_[쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[out] ppReader 쐬t@C[_[n Mix::IO::IReader C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateFileReader( const wchar_t* pFilePath, Mix::IO::IReader** ppReader ) = 0;
		//! @brief obt@h[_[쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[out] ppReader 쐬obt@h[_[n Mix::IO::IReader C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note obt@h[_[̓̃t@C𑀍삵܂
		virtual Boolean CreateBufferedReader( const wchar_t* pFilePath, Mix::IO::IReader** ppReader ) = 0;
		//! @brief obt@h[_[쐬܂
		//! @param[in] pFilePath O
		//! @param[in] pBuffer ǂݎ茳̃obt@\ Mix::Memory::IBuffer C^[tF[X̃|C^
		//! @param[out] ppReader 쐬obt@[_[n Mix::IO::IReader C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note obt@h[_[̓̃t@C𑀍삵܂
		virtual Boolean CreateBufferedReader( const wchar_t* pFilePath, Mix::Memory::IBuffer* pBuffer, Mix::IO::IReader** ppReader ) = 0;

		//! @brief t@CC^[쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[out] ppWriter 쐬t@CC^[n Mix::IO::IWriter C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note t@CC^[̍쐬ƓɁAt@C}Eg ( MountFile ) ܂B
		virtual Boolean CreateFileWriter( const wchar_t* pFilePath, Mix::IO::IWriter** ppWriter ) = 0;
	};

}}
