#pragma once

//! @file Mix/IEngine.h
//! @brief GWC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{

	//! @class IEngine
	//! @brief GWC^[tF[X
	class IEngine : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IEngine( void ){}

	public:
		//! @brief b̃t[Zbg܂
		virtual void ResetFPS( void ) = 0;
		//! @brief b̃t[擾܂
		//! @return b̃t[Ԃ܂
		virtual Float32 GetFPS( void ) const = 0;
		//! @brief ƂȂ閈b̃t[擾܂
		//! @return ƂȂ閈b̃t[Ԃ܂
		virtual Int32 GetBaseFPS( void ) const = 0;

		//! @brief b 1 t[̏v ( bP ) 擾܂
		//! @return b 1 t[̏vԂԂ܂
		virtual Float32 GetDT( void ) const = 0;
		//! @brief ƂȂ 1 t[̏v ( bP ) 擾܂
		//! @return ƂȂ 1 t[̏vԂԂ܂
		virtual Float32 GetBaseDT( void ) const = 0;

		//! @brief b̃X[vԂ擾܂
		//! @return X[vԂԂ܂
		virtual Float32 GetSleepTimePerSec( void ) const = 0;

		//! @brief b̃X[vԂɓȂ񐔂擾܂
		//! @return X[vԂɓȂ񐔂Ԃ܂
		virtual Int32 GetInsomniaFrameCountPerSec( void ) const = 0;
		//! @brief X[vԂɓȂꍇɑ̃XbhɃ^CXCX( Sleep( 0 ) )t[
		//! @return t[Ԃ܂
		virtual Int32 GetInsomniaFrameMax( void ) const = 0;

		//! @brief EBhẼnh擾܂
		//! @return EBhẼnhԂ܂
		virtual HWND GetWindowHandle( void ) const = 0;
		//! @brief NCAg̃TCY擾܂
		//! @return NCAg̃TCY\ Mix::Point NXԂ܂B
		virtual Mix::Point GetClientSize( void ) const = 0;

		//! @brief ANeBuǂmF܂
		//! @return ANeBuȏꍇ True Ԃ܂
		virtual Boolean IsActive( void ) const = 0;

		//! @brief ^Cgo[ɕ\LvV擾܂
		//! @return LvVԂ܂
		virtual const wchar_t* GetCaption( void ) const = 0;
		//! @brief ^Cgo[ɕ\LvVݒ肵܂
		//! @param[in] pCaption LvV
		virtual void SetCaption( const wchar_t* pCaption ) = 0;

		//! @brief EBhE铮擾܂
		//! @return EBhE̕{^Lȏꍇ True Ԃ܂
		virtual Boolean IsCloseEnabled( void ) const = 0;
		//! @brief EBhE̕铮ݒ肵܂
		//! @param[in] state EBhE̕铮Lɂꍇ True
		virtual void SetCloseEnabled( Boolean state ) = 0;

		//! @brief bZ[WvV[W[ݒ肵܂
		//! @param[in] pMsgProc bZ[W֐̃|C^
		//! @param[in] pData bZ[W֐ɓnf[^̃|C^
		virtual void SetMessageProc( Mix::MessageProcPtr pMsgProc, void* pData = NULL ) = 0;

		//! @brief GWXV܂
		//! @return XVpKvꍇ True Ԃ܂
		virtual Boolean Update( void ) = 0;

		//! @brief EBhEAGW~܂
		//! @note EBhE铮𖳌ɂĂꍇ́A@\܂B
		virtual void Shutdown( void ) = 0;
	};

}
