#pragma once

//! @file Mix/Geometry/AABB.h
//! @brief AABBNXCN[ht@C

namespace Mix{ namespace Geometry{

	class Sphere;

	//! @class AABB
	//! @brief AABBNX
	class _MIX_DLL_API AABB
	{
	public:
		Mix::Vector3 min;		//!< ŏl
		Mix::Vector3 max;		//!< ől
		Mix::Vector3 center;	//!< S
		Mix::Vector3 points[8];	//!< _Wz

	public:
		//! @brief RXgN^
		AABB( void );
		//! @brief RXgN^
		//! @param[in] _min ŏl
		//! @param[in] _max ől
		AABB( const Mix::Vector3& _min, const Mix::Vector3& _max );
		//! @brief RXgN^
		//! @param[in] sphere 鋅\ Mix::Geometry::Sphere NX
		AABB( const Mix::Geometry::Sphere& sphere );

	public:
		//! @brief _WŏlAől߂܂
		//! @return ߂ꂽ AABB \ Mix::Geometry::AABB NXԂ܂
		AABB& ComputeMinMax( void );
		//! @brief _WŏlAől߂܂
		//! @param[in] mat ϊs\ Mix::Matrix4x4 NX
		//! @return ߂ꂽ AABB \ Mix::Geometry::AABB NXԂ܂
		AABB& ComputeMinMax( const Mix::Matrix4x4& mat );
		//! @brief ݒ肳ꂽuŏlvuőlvAABB̒_W(8)߂܂
		//! @return ߂ꂽ AABB \ Mix::Geometry::AABB NXԂ܂
		AABB& ComputePoints( void );
		//! @brief ŏlAől璸_W߂܂
		//! @param[in] mat ϊs\ Mix::Matrix4x4 NX
		//! @return ߂ꂽ AABB \ Mix::Geometry::AABB NXԂ܂
		AABB& ComputePoints( const Mix::Matrix4x4& mat );

		//! @brief ܂
		//! @param[in] sphere 鋅\ Mix::Geometry::Sphere NX
		//! @return AABB\ Mix::Geometry::AABB NXԂ܂
		//! @note min max center ߂܂
		AABB& operator = ( const Mix::Geometry::Sphere& sphere );

		//! @brief AABB܂
		//! @param[in] aabb AABB\ Mix::Geometry::AABB NX
		//! @return AABB\ Mix::Geometry::AABB NXԂ܂
		AABB& operator += ( const Mix::Geometry::AABB& aabb );
		//! @brief ܂
		//! @param[in] sphere 鋅\ Mix::Geometry::Sphere NX
		//! @return AABB\ Mix::Geometry::AABB NXԂ܂
		AABB& operator += ( const Mix::Geometry::Sphere& sphere );
		//! @brief |Cg܂
		//! @param[in] point |Cg\ Mix::Vector3 NX
		//! @return AABB\ Mix::Geometry::AABB NXԂ܂
		AABB& operator += ( const Mix::Vector3& point );

		//! @brief AABB܂
		//! @param[in] aabb AABB\ Mix::Geometry::AABB NX
		//! @return AABB\ Mix::Geometry::AABB NXԂ܂
		AABB operator + ( const Mix::Geometry::AABB& aabb ) const;
		//! @brief ܂
		//! @param[in] sphere 鋅\ Mix::Geometry::Sphere NX
		//! @return AABB\ Mix::Geometry::AABB NXԂ܂
		AABB operator + ( const Mix::Geometry::Sphere& sphere ) const;
		//! @brief |Cg܂
		//! @param[in] point |Cg\ Mix::Vector3 NX
		//! @return AABB\ Mix::Geometry::AABB NXԂ܂
		AABB operator + ( const Mix::Vector3& point ) const;
	};

}}
