// Momiji.Test.DeviceInfo.cpp : C vWFNg t@CłB

#include "stdafx.h"
#using <Momiji.Core.dll>

using namespace System;

void test10()
{

	try
	{
		auto devices = 
			gcnew Momiji::Core::DeviceInfo::Devices(
				Momiji::Interop::Ks::StaticKs::CATEGORY_AUDIO,
				(
						Momiji::Interop::Setupapi::DIGCF::PRESENT 
					|	Momiji::Interop::Setupapi::DIGCF::DEVICEINTERFACE
				),
				nullptr
			);

		auto detailList = gcnew System::Collections::Generic::List<Momiji::Core::DeviceInfo::Devices::Detail^>;
		try
		{
			for each(Momiji::Core::DeviceInfo::Devices::Detail^ detail in devices->Enum)
			{
				for each(Momiji::Interop::Setupapi::SPDRP spdrp in System::Enum::GetValues(Momiji::Interop::Setupapi::SPDRP::typeid)) {
					detail->GetDeviceRegistryProperty(spdrp);
				}

				detail->GetDeviceRegistryProperty("FriendlyName");

				auto alias = detail->GetAlias(Momiji::Interop::Ks::StaticKs::CATEGORY_RENDER);
				if (alias == nullptr)
				{
					continue;
				}

				if ((alias->Flags & Momiji::Interop::Setupapi::SPINT::REMOVED) == Momiji::Interop::Setupapi::SPINT::REMOVED)
				{
					System::Console::WriteLine("폜ς");
					continue;
				}
				detailList->Add(detail);
			}

		}
		finally
		{
			delete devices;
		}

		for each(Momiji::Core::DeviceInfo::Devices::Detail^ detail in detailList) {

			//Momiji::Core::DeviceInfo::Devices::Detail^ detail = System::Linq::Enumerable::Last(detailList);

			//ŌĂяoƁAƃG[ɂȂ
			try
			{
				detail->GetAlias(Momiji::Interop::Ks::StaticKs::CATEGORY_CAPTURE);
			}
			catch(System::ObjectDisposedException^ e)
			{
				System::Console::WriteLine("Devices͑łȂ [{0}]", e);
			}

			auto filter = gcnew Momiji::Core::Ks::Filter(detail->DevicePath);
			try
			{
				for each (auto p in filter->propertySetPin->Items)
				{
					try
					{
						auto pin = 
							gcnew Momiji::Core::Ks::Pin<System::UInt16>(
								p,
								2, 
								48000, 
								16, 
								(
										Momiji::Interop::Winmm::WaveFormatExtensiblePart::SPEAKER::FRONT_LEFT
									|	Momiji::Interop::Winmm::WaveFormatExtensiblePart::SPEAKER::FRONT_RIGHT
								),
								Momiji::Interop::Ks::StaticKs::SUBTYPE_PCM
							);

						try
						{
							pin->Test();
							Console::WriteLine("====================================================");
							System::Console::ReadLine();
						}
						finally
						{
							delete pin;
						}
					}
					catch(System::Exception^ e)
					{
						Console::WriteLine("Pin Error {0}", e);
						Console::WriteLine("====================================================");
						System::Console::ReadLine();
					}
				}
			}
			finally
			{
				delete filter;
				Console::WriteLine("");
				Console::WriteLine("delete filter ====================================================");
				Console::WriteLine("");
			}
			System::Console::ReadLine();
		}
	}
	catch(System::Exception^ e)
	{
		Console::WriteLine("ERROR:{0}", e);
	}


}

int main(array<System::String ^> ^args)
{
	test10();
	System::GC::Collect();
	System::GC::WaitForPendingFinalizers();
	System::GC::Collect();

	Console::WriteLine("====================================================");
	System::Console::ReadLine();
    return 0;
}
