// Momiji.Test.Sequencer.Midi.cpp : C vWFNg t@CłB

#include "stdafx.h"

#using <Momiji.Core.dll>
#using <System.Windows.Forms.dll>

using namespace System;

void test9()
{
	System::String^ fileName;
	System::Windows::Forms::OpenFileDialog^ dialog = gcnew System::Windows::Forms::OpenFileDialog();
	try
	{
		dialog->InitialDirectory = System::IO::Directory::GetCurrentDirectory();
		dialog->Filter = "midi|*.mid";
		if (dialog->ShowDialog() == System::Windows::Forms::DialogResult::Cancel)
		{
			Console::WriteLine("============ ");
			return;
		}

		fileName = dialog->FileName;
	}
	finally
	{
		delete dialog;
	}

	Momiji::Core::ITimer^ t;
	Momiji::Core::IStream^ s;
	Momiji::Core::Midi::Out::Devices^ o;
	Momiji::Controler::Player^ p;
	try
	{
		t = gcnew Momiji::Core::Timer::MMTimer();
		s = gcnew Momiji::Sequencer::Midi::Smf::SmfStream(fileName);
		o = gcnew Momiji::Core::Midi::Out::Devices();
		o->AddPort(0);
		o->AddPort(11);

		p = gcnew Momiji::Controler::Player();
		p->Assign(t);
		p->Assign(s);
		p->Assign(o);

		p->Start();
		Console::WriteLine("============ enter stop");
		System::Console::ReadLine();
		p->Stop();

		Console::WriteLine("============ enter start");
		System::Console::ReadLine();
		p->Start();

		Console::WriteLine("============ enter stop - rewind - start");
		System::Console::ReadLine();
		p->Stop();
		s->Rewind();

		p->Start();
		Console::WriteLine("============ enter stop");
		System::Console::ReadLine();
		p->Stop();
	}
	catch(Exception^ e)
	{
		Console::WriteLine(e->ToString());
	}
	finally
	{
		if (p != nullptr)
		{
			delete p;
		}

		if (s != nullptr)
		{
			delete s;
		}
		if (t != nullptr)
		{
			delete t;
		}
		if (o != nullptr)
		{
			delete o;
		}
	}
}

[System::STAThread]
int main(array<System::String ^> ^args)
{
	Console::WriteLine("====================================================test8");
	test9();
	System::GC::Collect();
	System::GC::WaitForPendingFinalizers();
	System::GC::Collect();

	Console::WriteLine("====================================================");
	System::Console::ReadLine();
    return 0;
}
