#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

VER=2.17
TARGET=glibc-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR
rm -fr glibc-build

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

echo \ \ Patching...
patch -Np1 -i $DLD/glibc-$VER-fhs-1.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

mkdir -v ../glibc-build
cd ../glibc-build

echo \ \ Configuring...
../glibc-$VER/configure  \
    --prefix=/usr          \
    --libexecdir=/usr/lib  \
    --disable-profile      \
    --enable-kernel=2.6.25 \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
touch /etc/ld.so.conf
#paco -p $TARGET "make install" \
make install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

echo \ \ Copying headers for libtirpc...
paco -p+ $TARGET "\
cp -v ../glibc-$VER/sunrpc/rpc/*.h /usr/include/rpc" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
cp -v ../glibc-$VER/sunrpc/rpcsvc/*.h /usr/include/rpcsvc" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
cp -v ../glibc-$VER/nis/rpcsvc/*.h /usr/include/rpcsvc" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m644 ../glibc-2.17/nscd/nscd.conf /etc/nscd.conf" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
install -v -dm755 /var/cache/nscd" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "mkdir -pv /usr/lib/locale"
paco -p+ $TARGET "localedef -i cs_CZ -f UTF-8 cs_CZ.UTF-8"
paco -p+ $TARGET "localedef -i de_DE -f ISO-8859-1 de_DE"
paco -p+ $TARGET "localedef -i de_DE@euro -f ISO-8859-15 de_DE@euro"
paco -p+ $TARGET "localedef -i de_DE -f UTF-8 de_DE.UTF-8"
paco -p+ $TARGET "localedef -i en_HK -f ISO-8859-1 en_HK"
paco -p+ $TARGET "localedef -i en_PH -f ISO-8859-1 en_PH"
paco -p+ $TARGET "localedef -i en_US -f ISO-8859-1 en_US"
paco -p+ $TARGET "localedef -i en_US -f UTF-8 en_US.UTF-8"
paco -p+ $TARGET "localedef -i es_MX -f ISO-8859-1 es_MX"
paco -p+ $TARGET "localedef -i fa_IR -f UTF-8 fa_IR"
paco -p+ $TARGET "localedef -i fr_FR -f ISO-8859-1 fr_FR"
paco -p+ $TARGET "localedef -i fr_FR@euro -f ISO-8859-15 fr_FR@euro"
paco -p+ $TARGET "localedef -i fr_FR -f UTF-8 fr_FR.UTF-8"
paco -p+ $TARGET "localedef -i it_IT -f ISO-8859-1 it_IT"
paco -p+ $TARGET "localedef -i ja_JP -f EUC-JP ja_JP"
paco -p+ $TARGET "localedef -i ja_JP -f UTF-8 ja_JP.UTF-8"
paco -p+ $TARGET "localedef -i tr_TR -f UTF-8 tr_TR.UTF-8"
paco -p+ $TARGET "localedef -i zh_CN -f GB18030 zh_CN.GB18030"

cat > /etc/nsswitch.conf << "EOF"
# Begin /etc/nsswitch.conf

passwd: files
group: files
shadow: files

hosts: files dns
networks: files

protocols: files
services: files
ethers: files
rpc: files

# End /etc/nsswitch.conf
EOF
paco -p+ $TARGET "touch /etc/nsswitch.conf"

tar -xf $DLD/tzdata2012j.tar.gz

mkdir -pv /usr/share/zoneinfo/{posix,right}

for tz in etcetera southamerica northamerica europe africa antarctica \
          asia australasia backward pacificnew solar87 solar88 solar89 systemv; do
    zic -L /dev/null   -d /usr/share/zoneinfo       -y "sh yearistype.sh" ${tz}
    zic -L /dev/null   -d /usr/share/zoneinfo/posix -y "sh yearistype.sh" ${tz}
    zic -L leapseconds -d /usr/share/zoneinfo/right -y "sh yearistype.sh" ${tz}
done

paco -p+ $TARGET "\
cp -v zone.tab iso3166.tab /usr/share/zoneinfo"

paco -p+ $TARGET "\
zic -d /usr/share/zoneinfo -p America/New_York"

paco -p+ $TARGET "tzselect"

paco -p+ $TARGET "\
cp -v --remove-destination /usr/share/zoneinfo/Japan \
    /etc/localtime"

cat > /etc/ld.so.conf << "EOF"
# Begin /etc/ld.so.conf
/usr/local/lib
/opt/lib

EOF
paco -p+ $TARGET "touch /etc/ld.so.conf"

paco -p+ $TARGET "mkdir /etc/ld.so.conf.d"

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR && rm -fr glibc-build

echo \ \ Done.

