#/bin/sh

CHAP=6
APPNAME=attr
VER=2.4.47
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.src.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

sed -i -e 's|/@pkg_name@|&-@pkg_version@|' include/builddefs.in

sed -i -e "/SUBDIRS/s|man2||" man/Makefile

echo \ \ Configuring...
./configure --prefix=/usr \
            --bindir=/bin \
            --disable-static \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET "\
make install install-dev install-lib" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
chmod 755 /usr/lib/libattr.so

porg -lp+ $TARGET "\
mv -v /usr/lib/libattr.so.* /lib" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -sfv ../../lib/$(readlink /usr/lib/libattr.so) /usr/lib/libattr.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

