#/bin/sh

. ./_clfsset.sh

APPNAME=cloog
VER=0.18.2
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo Configuring...
LDFLAGS="-Wl,-rpath,/cross-tools/lib" \
    ./configure --prefix=/cross-tools --disable-static \
    --with-gmp-prefix=/cross-tools --with-isl-prefix=/cross-tools \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

cp Makefile{,.orig}
sed '/cmake/d' Makefile.orig > Makefile

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.

