#/bin/sh

. ./_clfsset.sh

APPNAME=perl
VER=5.20.0
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir

. $WRK/_extract.sh

cd $TARGETDIR

TimeStart

sed -i 's@/usr/include@/tools/include@g' ext/Errno/Errno_pm.PL

echo Configuring...
./configure.gnu --prefix=/tools  -Dcc="gcc ${BUILD32}" \
        1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
        1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
        1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -sfv /tools/bin/perl /usr/bin \
        1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.

