#/bin/sh

. ./_clfsset.sh

APPNAME=libcap
VER=2.24
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo Making...
make CC="gcc ${BUILD32}" \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make RAISE_SETFCAP=no lib=lib install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
chmod -v 755 /lib/libcap.so.2.24 \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -sfv ../../lib/$(readlink /lib/libcap.so) /usr/lib/libcap.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
rm -v /lib/libcap.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
mv -v /lib/libcap.a /usr/lib \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.

