#/bin/sh

. ./_clfsset.sh

APPNAME=iputils
VER=s20121221
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/iputils-s20121221-fixes-2.patch \
	1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

echo Making...
make CC="gcc ${BUILD64}" \
    IPV4_TARGETS="tracepath ping clockdiff rdisc" \
    IPV6_TARGETS="tracepath6 traceroute6" \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
install -v -m755 ping /bin \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
install -v -m755 clockdiff /usr/bin \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
install -v -m755 rdisc /usr/bin \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
install -v -m755 tracepath /usr/bin \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
install -v -m755 trace{path,route}6 /usr/bin \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
install -v -m644 doc/*.8 /usr/share/man/man8 \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
