#!/bin/sh

. ./_blfsset.sh

APPNAME=usbutils
VER=008
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$APPNAME-$VER.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	libusb python-2
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i '/^usbids/ s:usb.ids:hwdata/&:' lsusb.py

Configuring
./configure --prefix=/usr \
            --datadir=/usr/share/hwdata \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

mkdir -p /usr/share/hwdata
rm -f /usr/share/hwdata/usb.ids
wget http://www.linux-usb.org/usb.ids -O /usr/share/hwdata/usb.ids \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
touch /usr/share/hwdata/usb.ids" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

