#!/bin/sh

CDROM=/mnt/cdrom/archive
TGTTOPDIR=/opt/texlive/share

mkdir -p $TGTTOPDIR/texmf-dist

# without texmf-dist
ARCS="\
	adobemapping.tar.xz  \
	amscls.tar.xz        \
	amsfonts.tar.xz      \
	babel.tar.xz         \
	cm.tar.xz            \
	courier.tar.xz       \
	dehyph-exptl.tar.xz  \
	ec.tar.xz            \
	etex.tar.xz          \
	fontaxes.tar.xz      \
	helvetic.tar.xz      \
	hyphen-ancientgreek.tar.xz \
	hyphen-base.tar.xz   \
	hyphen-german.tar.xz \
	hyphen-greek.tar.xz  \
	hyph-utf8.tar.xz     \
	jsclasses.tar.xz     \
	latex.tar.xz         \
	latexconfig.tar.xz   \
	latex-fonts.tar.xz   \
	latex.source.tar.xz  \
	mflogo.tar.xz        \
	mflogo.source.tar.xz \
	misc.tar.xz          \
	newtx.tar.xz         \
	plain.tar.xz         \
	psnfss.tar.xz        \
	ruhyphen.tar.xz      \
	times.tar.xz         \
	txfonts.tar.xz       \
	ukrhyph.tar.xz       \
	xkeyval.tar.xz       \
"

pushd $CDROM >/dev/null

for ARC in $ARCS
do
  echo $ARC...
  tar xf $ARC -C $TGTTOPDIR/texmf-dist
done

popd > /dev/null

# with texmf-dist
ARCS="\
        dvipdfmx.tar.xz    \
	dvips.tar.xz       \
        kpathsea.tar.xz    \
        pdftex.tar.xz      \
        ptex.tar.xz        \
"

pushd $CDROM >/dev/null

for ARC in $ARCS
do
  echo $ARC...
  tar xf $ARC -C $TGTTOPDIR
done

popd > /dev/null

