#!/bin/sh

LFS=/mnt/lfs
WRK=$LFS/work/LFScripts/BLFS

F=mozconfig

IsInstalled() {
  paco -i $1 > /dev/null 2>&1
  echo $?
}

cat $WRK/$F.src > $F

PKG=dbus-glib
ret=`IsInstalled $PKG`
if [ $ret == 0 ]; then
  sed -i '/disable\-dbus/s/^/# /' $F
fi

PKG=wireless_tools
ret=`IsInstalled $PKG`
if [ $ret == 0 ]; then
  sed -i '/disable\-necko\-wifi/s/^/# /' $F
fi

PKG=libnotify
ret=`IsInstalled $PKG`
if [ $ret == 0 ]; then
  sed -i '/disable\-libnotify/s/^/# /' $F
fi

PKG=gstreamer-0
ret=`IsInstalled $PKG`
if [ $ret != 0 ]; then
  sed -i '/disable\-gstreamer/s/^#//' $F
fi

PKG=gstreamer-1
ret=`IsInstalled $PKG`
if [ $ret == 0 ]; then
  sed -i '/enable\-gstreamer/s/^#//' $F
fi

PKG=hunspell
ret=`IsInstalled $PKG`
if [ $ret == 0 ]; then
  sed -i '/enable\-system\-hunspell/s/^#//' $F
fi

PKG=startup-notification
ret=`IsInstalled $PKG`
if [ $ret == 0 ]; then
  sed -i '/enable\-startup\-notification/s/^#//' $F
fi

PKG=pulseaudio
ret=`IsInstalled $PKG`
if [ $ret == 0 ]; then
  sed -i '/disable\-pulseaudio/s/^/#/' $F
fi

PKG=yasm
ret=`IsInstalled $PKG`
if [ $ret != 0 ]; then
  sed -i '/disable\-webm/s/^#//' $F
fi

PKG=sqlite
ret=`IsInstalled $PKG`
if [ $ret != 0 ]; then
  sed -i '/enable\-system\-sqlite/s/^/# /' $F
fi

PKG=libevent
ret=`IsInstalled $PKG`
if [ $ret != 0 ]; then
  sed -i '/with\-system\-libevent/s/^/# /' $F
fi

PKG=libvpx
ret=`IsInstalled $PKG`
if [ $ret != 0 ]; then
  sed -i '/with\-system\-libvpx/s/^/# /' $F
fi

PKG=nspr
ret=`IsInstalled $PKG`
if [ $ret != 0 ]; then
  sed -i '/with\-system\-nspr/s/^/# /' $F
fi

PKG=nss
ret=`IsInstalled $PKG`
if [ $ret != 0 ]; then
  sed -i '/with\-system\-nss/s/^/# /' $F
fi

PKG=icu
ret=`IsInstalled $PKG`
if [ $ret != 0 ]; then
  sed -i '/with\-system\-icu/s/^/# /' $F
fi
