#!/bin/sh

. ../_blfsset.sh
. ./_lxdeset.sh

APPNAME=lxpolkit
VER=0.1.0
TARGET=$APPNAME-$VER
TARGETBALL=$LXDEDLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
        gtk+-2 menu-cache polkit
. $WRK/_checkOptions.sh  \
	gtk+-3
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
	--sysconfdir=/etc \
        --libexecdir=/usr/lib/lxpolkit \
$([ "${OPTION_gtk3}" -eq 1 ] && echo --enable-gtk3) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

