#!/bin/sh

. ../_blfsset.sh
. ./_lxdeset.sh

APPNAME=lxde-common
VER=0.5.5
TARGET=$APPNAME-$VER
TARGETBALL=$LXDEDLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	consolekit lxde-icon-theme lxpanel lxsession \
	openbox pcmanfm
. $WRK/_checkOptions.sh docbook-xml docbook-xsl
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -e "s:@prefix@/share/lxde/pcmanfm:@sysconfdir@/xdg/pcmanfm/LXDE:" \
    -i startlxde.in

Configuring
./configure --prefix=/usr \
	--sysconfdir=/etc \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
install -Dm644 lxde-logout.desktop \
/usr/share/applications/lxde-logout.desktop" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

update-mime-database /usr/share/mime
gtk-update-icon-cache -qf /usr/share/icons/hicolor
update-desktop-database -q

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

