#!/bin/sh

. ./_blfsset.sh

APPNAME=cracklib
VER=2.9.5
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  python-2
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i '/skipping/d' util/packer.c

Configuring
./configure --prefix=/usr \
            --with-default-dict=/lib/cracklib/pw_dict \
	    --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
mv -v /usr/lib/libcrack.so.* /lib" \
	1>> $LOG/$TARGET.3_install.log 2>&1
porg -lp+ $TARGET "\
ln -sfv ../../lib/$(readlink /usr/lib/libcrack.so) /usr/lib/libcrack.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1

porg -lp+ $TARGET "\
install -v -m644 -D $DLD/cracklib-words-20080507.gz \
    /usr/share/dict/cracklib-words.gz" \
	1>> $LOG/$TARGET.3_install.log 2>&1

porg -lp+ $TARGET "\
gunzip -v /usr/share/dict/cracklib-words.gz" \
	1>> $LOG/$TARGET.3_install.log 2>&1
porg -lp+ $TARGET 'ln -v -s cracklib-words /usr/share/dict/words' \
	1>> $LOG/$TARGET.3_install.log 2>&1

echo $(hostname) >>/usr/share/dict/cracklib-extra-words
porg -lp+ $TARGET "cp $DLD/japanese /usr/share/dict" \
	1>> $LOG/$TARGET.3_install.log 2>&1
porg -lp+ $TARGET 'install -v -m755 -d /lib/cracklib' \
	1>> $LOG/$TARGET.3_install.log 2>&1
porg -lp+ $TARGET 'create-cracklib-dict /usr/share/dict/cracklib-words \
                     /usr/share/dict/cracklib-extra-words \
                     /usr/share/dict/japanese' \
	1>> $LOG/$TARGET.3_install.log 2>&1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

