#!/bin/sh

. ./_blfsset.sh

APPNAME=Linux-PAM
VER=1.2.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	db cracklib libtirpc libprelude
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

if [ ${OPTION_libtirpc} -eq "1" ]; then
  export DISABLENIS=""
else
  export DISABLENIS="--disable-nis "
fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
	    --sysconfdir=/etc \
            --libdir=/usr/lib \
            --enable-securedir=/lib/security \
            --docdir=/usr/share/doc/Linux-PAM-$VER \
            $DISABLENIS \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

chmod -v 4755 /sbin/unix_chkpwd \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

for file in pam pam_misc pamc
do
  porg -lp+ $TARGET "\
  mv -v /usr/lib/lib${file}.so.* /lib" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

  porg -lp+ $TARGET "\
  ln -sfv ../../lib/$(readlink /usr/lib/lib${file}.so) /usr/lib/lib${file}.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
done

install -v -m755 -d /etc/pam.d

cat > /etc/pam.d/other << "EOF"
# Begin /etc/pam.d/other

auth            required        pam_unix.so     nullok
account         required        pam_unix.so
session         required        pam_unix.so
password        required        pam_unix.so     nullok

# End /etc/pam.d/other
EOF
porg -lp+ $TARGET "touch /etc/pam.d/other"

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

