#/bin/sh

CHAP=6
APPNAME=gcc
VER=5.2.0
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR
rm -fr gcc-build

. $WRK/_extract.sh

cd $TARGETDIR

TimeStart

#echo \ \ Patching...
#patch -Np1 -i $DLD/gcc-5.1.0-upstream_fixes-1.patch \
#	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

mkdir ../gcc-build
cd ../gcc-build

echo \ \ Configuring...
SED=sed                       \
../gcc-$VER/configure         \
     --prefix=/usr            \
     --enable-languages=c,c++ \
     --disable-multilib       \
     --disable-bootstrap      \
     --with-system-zlib       \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
ln -sfv ../usr/bin/cpp /lib" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -sfv gcc /usr/bin/cc" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
install -v -dm755 /usr/lib/bfd-plugins" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -sfv ../../libexec/gcc/$(gcc -dumpmachine)/$VER/liblto_plugin.so /usr/lib/bfd-plugins/" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

echo 'main(){}' > dummy.c
cc dummy.c -v -Wl,--verbose &> dummy.log
readelf -l a.out | grep ': /lib'

grep -o '/usr/lib.*/crt[1in].*succeeded' dummy.log

grep -B4 '^ /usr/include' dummy.log

grep 'SEARCH.*/usr/lib' dummy.log |sed 's|; |\n|g'

grep "/lib.*/libc.so.6 " dummy.log

grep found dummy.log

rm -v dummy.c a.out dummy.log

#case `uname -m` in
#  i?86) GDBDIR=/usr/share/gdb/auto-load/usr/lib/   ;;
#  *)    GDBDIR=/usr/share/gdb/auto-load/usr/lib64/ ;;
#esac

#mkdir -pv $GDBDIR
#paco -p+ $TARGET "\
#mv -v /usr/lib/*gdb.py $GDBDIR" \
#	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1
#unset GDBDIR

mkdir -p /usr/share/gdb/auto-load/usr/lib
porg -lp+ $TARGET "\
mv -v /usr/lib/*gdb.py /usr/share/gdb/auto-load/usr/lib" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR && rm -fr gcc-build

echo \ \ Done.

