#/bin/sh

CHAP=6
APPNAME=acl
VER=2.2.52
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.src.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

sed -i -e 's|/@pkg_name@|&-@pkg_version@|' include/builddefs.in
sed -i "s:| sed.*::g" test/{sbits-restore,cp,misc}.test
sed -i -e "/TABS-1;/a if (x > (TABS-1)) x = (TABS-1);" \
    libacl/__acl_to_any_text.c

echo \ \ Configuring...
./configure --prefix=/usr    \
            --bindir=/bin    \
            --disable-static \
            --libexecdir=/usr/lib \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET "\
make install install-dev install-lib" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
chmod 755 /usr/lib/libacl.so

porg -lp+ $TARGET "\
mv -v /usr/lib/libacl.so.* /lib" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -sfv ../../lib/$(readlink /usr/lib/libacl.so) /usr/lib/libacl.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

