#/bin/sh

CHAP=5
APPNAME=tcl
VER=8.6.4
TARGET=$APPNAME-core$VER
TARGETBALL=${TARGET}-src.tar.gz
TARGETDIR=$APPNAME$VER

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Configuring...
cd unix
./configure --prefix=/tools \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

chmod u+w /tools/lib/libtcl8.6.so \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

echo \ \ Installing...
make install-private-headers \
	1> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

ln -sv tclsh8.6 /tools/bin/tclsh \
	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

TimeEnd chap5

echo \ \ Removing directory...
cd ../.. && rm -fr $TARGETDIR

echo \ \ Done.

