#/bin/sh

. ./_clfsset.sh
. ./_6clfsset.sh

APPNAME=binutils
VER=2.24
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
rm -fr binutils-build

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

mkdir ../binutils-build
cd ../binutils-build

echo Configuring...
../binutils-$VER/configure \
    --prefix=/tools --libdir=/tools/lib64 --with-lib-path=/tools/lib64:/tools/lib \
    --build=${CLFS_HOST} --host=${CLFS_TARGET} --target=${CLFS_TARGET} \
    --disable-nls --enable-shared --enable-64-bit-bfd \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
rm -fr binutils-build

echo Done.

