#/bin/sh

. ./_clfsset.sh

APPNAME=gcc
VER=4.8.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
rm -fr gcc-build
Extract
TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/gcc-4.8.3-branch_update-1.patch \
	1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

sed -i 's@\./fixinc\.sh@-c true@' gcc/Makefile.in

mkdir ../gcc-build
cd ../gcc-build

echo Configuring...
SED=sed CC="gcc -isystem /usr/include ${BUILD64}" \
CXX="g++ -isystem /usr/include ${BUILD64}" \
LDFLAGS="-Wl,-rpath-link,/usr/lib64:/lib64:/usr/lib:/lib" \
  ../gcc-4.8.3/configure --prefix=/usr --libdir=/usr/lib64 \
    --libexecdir=/usr/lib64 --enable-threads=posix --enable-__cxa_atexit \
    --enable-clocale=gnu --enable-languages=c,c++ --disable-libstdcxx-pch \
    --with-system-zlib --enable-checking=release --enable-libstdcxx-time \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
cp -v ../gcc-4.8.3/include/libiberty.h /usr/include \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -sv ../usr/bin/cpp /lib \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
mv -v /usr/lib/libstdc++*gdb.py /usr/share/gdb/auto-load/usr/lib \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
mv -v /usr/lib64/libstdc++*gdb.py /usr/share/gdb/auto-load/usr/lib64 \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
rm -fr gcc-build

echo Done.
