#/bin/sh

. ./_clfsset.sh

APPNAME=expat
VER=2.1.0
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD64}" CXX="g++ ${BUILD64}" ./configure \
    --prefix=/usr --libdir=/usr/lib64 \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
porg -lp+ $TARGET "\
make install" \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

install -v -m755 -d /usr/share/doc/expat-2.1.0 \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
install -v -m644 doc/*.{html,png,css} /usr/share/doc/expat-2.1.0" \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.

