#/bin/sh

. ./_clfsset.sh

APPNAME=diffutils
VER=3.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

sed -i 's:= @mkdir_p@:= /bin/mkdir -p:' po/Makefile.in.in

echo Configuring...
CC="gcc ${BUILD64}" ./configure --prefix=/usr \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

sed -i 's@\(^#define DEFAULT_EDITOR_PROGRAM \).*@\1"vi"@' lib/config.h

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
