#/bin/sh

. ./_clfsset.sh

APPNAME=cloog
VER=0.18.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc -isystem /usr/include ${BUILD64}" \
LDFLAGS="-Wl,-rpath-link,/usr/lib64:/lib64 ${BUILD64}" \
  ./configure --prefix=/usr --libdir=/usr/lib64 --with-isl=system \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
sed -i '/cmake/d' Makefile
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
