#!/bin/sh

. ./_blfsset.sh

APPNAME=xfsprogs
VER=3.1.10
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Making
make DEBUG=-DNDEBUG INSTALL_USER=root INSTALL_GROUP=root \
     LOCAL_CONFIGURE_OPTIONS="--enable-readline" \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "\
make install install-dev" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
rm -rfv /lib/libhandle.{a,la,so}" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
ln -sfv ../../lib/libhandle.so.1 /usr/lib/libhandle.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

sed -i "s@libdir='/lib@libdir='/usr/lib@g" /usr/lib/libhandle.la

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

