#!/bin/sh

. ./_blfsset.sh

APPNAME=wget
VER=1.16.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	openssl gnutls libidn dante
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

if [ ${OPTION_gnutls} -eq 1 ]; then
  export WITHGNUTLS=" "
else
  export WITHGNUTLS="--with-ssl=openssl "
fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#echo Unofficial patch...
#patch -Np1 -i $DLD/wget-1.14-perl-5.18-pod-fixes.diff \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr --sysconfdir=/etc \
	$WITHGNUTLS \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

#porg -lp+ $TARGET "\
#install-info --info-dir=/usr/share/info /usr/share/info/wget.info" \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

