#!/bin/sh

. ./_blfsset.sh

APPNAME=vim
VER=7.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=${APPNAME}73

echo $TARGET

. $WRK/_checkRequired.sh \
	Xorg-lib-libX11
. $WRK/_checkOptions.sh  \
	gtk+-2 lesstiff python-2 tcl ruby gpm
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/vim-$VER-fixes-524.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

tar -xf $DLD/vim-7.2-lang.tar.gz --strip-components=1 \
	1> /dev/null 2>&1 || exit 1

echo '#define SYS_VIMRC_FILE "/etc/vimrc"' >> src/feature.h
echo '#define SYS_GVIMRC_FILE "/etc/gvimrc"' >> src/feature.h

Configuring
./configure --prefix=/usr --with-features=huge \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

ln -snfv ../vim/vim73/doc /usr/share/doc/vim-7.3

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

