#!/bin/sh

. ./_blfsset.sh

APPNAME=sqlite
VER=3.8.11.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/${APPNAME}-autoconf-3081101.tar.gz
TARGETDIR=${APPNAME}-autoconf-3081101

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  unzip
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr --disable-static        \
            CFLAGS="-g -O2 -DSQLITE_ENABLE_FTS3=1 \
            -DSQLITE_ENABLE_COLUMN_METADATA=1     \
            -DSQLITE_ENABLE_UNLOCK_NOTIFY=1       \
            -DSQLITE_SECURE_DELETE=1"             \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

