#!/bin/sh

. ../_blfsset.sh
. ./_kdeset.sh

APPNAME=kdelibs
VER=4.14.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	phonon attica strigi \
        libdbusmenu-qt docbook-xml docbook-xsl \
        shared-mime-info
. $WRK/_checkOptions.sh  \
	polkit-qt libpng libjpeg-turbo giflib upower \
	jasper pcre avahi openssl acl aspell enchant \
	grantlee krb5 hspell fam hupnp openexr media-player-info \
        soprano qca shared-desktop-ontologies
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i "s@{SYSCONF_INSTALL_DIR}/xdg/menus@& RENAME kde-applications.menu@" \
        kded/CMakeLists.txt &&
sed -i "s@applications.menu@kde-&@" \
        kded/kbuildsycoca.cpp

mkdir build
cd build

echo Cmaking...
cmake -DCMAKE_INSTALL_PREFIX=$KDE_PREFIX \
      -DSYSCONF_INSTALL_DIR=/etc \
      -DCMAKE_BUILD_TYPE=Release \
      -DDOCBOOKXML_CURRENTDTD_DIR=/usr/share/xml/docbook/xml-dtd-4.5 \
      -Wno-dev \
      .. \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PacoingDone

