#!/bin/sh

. ./_blfsset.sh

APPNAME=jdk
VER=1.7.0_15
UVER=7u15
TARGET=$APPNAME-$VER
TARGETDIR=${APPNAME}$VER
TARGETBALL=jdk-$UVER-linux-i586.tar.gz

cd $SRC

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

install -v -m755 -d /opt/jdk-$UVER

paco -p+ $TARGET "mv -v * /opt/jdk-$UVER" \
	1> $LOG/$TARGET.1_move.log 2>&1 || exit 1

chown -v -R root:root /opt/jdk-$UVER\
	1> $LOG/$TARGET.2_chown.log 2>&1 || exit 1

paco -p+ $TARGET "ln -v -sf xawt/libmawt.so \
    /opt/jdk-$UVER/jre/lib/i386/"

pushd /opt

sed -i 's@XINERAMA@FAKEEXTN@g' \
    /opt/jdk-$UVER/jre/lib/i386/xawt/libmawt.so

paco -p+ $TARGET "ln -v -nsf jdk-$UVER /opt/jdk"

cat > /etc/profile.d/jdk.sh << "EOF"
# Begin /etc/profile.d/jdk.sh

# Set JAVA_HOME directory
JAVA_HOME=/opt/jdk

# Adjust PATH
pathappend ${JAVA_HOME}/bin PATH

# Auto Java CLASSPATH
# Copy jar files to, or create symlinks in this directory
AUTO_CLASSPATH_DIR=/usr/lib/classpath
pathprepend . CLASSPATH
for dir in `find ${AUTO_CLASSPATH_DIR} -type d 2>/dev/null`; do
    pathappend $dir CLASSPATH
done

export JAVA_HOME CLASSPATH
unset AUTO_CLASSPATH_DIR
unset dir

# End /etc/profile.d/jdk.sh
EOF

popd

paco -p+ $TARGET "touch /etc/profile.d/jdk.sh"

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

