#!/bin/sh

. ./_blfsset.sh

APPNAME=jdk
VER=1.8.0_31
UVER=8u31
TARGET=$APPNAME-$VER
TARGETDIR=${APPNAME}$VER
TARGETBALL=jdk-$UVER-linux-x64.tar.gz

echo $TARGET

cd $SRC

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

install -v -m755 -d /opt/jdk-$UVER

porg -lp+ $TARGET "mv -v * /opt/jdk-$UVER" \
	1> $LOG/$TARGET.1_move.log 2>&1 || exit 1

chown -v -R root:root /opt/jdk-$UVER\
	1> $LOG/$TARGET.2_chown.log 2>&1 || exit 1

cd /opt

porg -lp+ $TARGET "ln -v -nsf jdk-$UVER /opt/jdk"

cat > /etc/profile.d/jdk.sh << "EOF"
# Begin /etc/profile.d/jdk.sh

# Set JAVA_HOME directory
JAVA_HOME=/opt/jdk

# Adjust PATH
pathappend ${JAVA_HOME}/bin PATH

# Auto Java CLASSPATH
# Copy jar files to, or create symlinks in this directory
AUTO_CLASSPATH_DIR=/usr/lib/classpath
pathprepend . CLASSPATH
for dir in `find ${AUTO_CLASSPATH_DIR} -type d 2>/dev/null`; do
    pathappend $dir CLASSPATH
done

export JAVA_HOME CLASSPATH
unset AUTO_CLASSPATH_DIR
unset dir

# End /etc/profile.d/jdk.sh
EOF

porg -lp+ $TARGET "touch /etc/profile.d/jdk.sh"

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

