#!/bin/sh

. ./_blfsset.sh

APPNAME=jbigkit
VER=2.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

Making
make CC="gcc -fPIC" \
	1> $LOG/$TARGET.1_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "\
cp pbmtools/{pbmtojbg,pbmtojbg85,jbgtopbm85,jbgtopbm} /usr/bin && \
cp libjbig/{tstcodec,tstcodec85} /usr/bin && \
cp libjbig/{libjbig.a,libjbig85.a} /usr/lib && \
cp libjbig/*.h /usr/include" \
	1> $LOG/$TARGET.2_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

echo -n Porging:\   && porg $TARGET || echo none

echo Removing directory...
cd .. && rm -fr $TARGETDIR

