#!/bin/sh

. ../_blfsset.sh
. ./_gnomeset.sh

APPNAME=gnome-screensaver
VER=3.6.1
TARGET=$APPNAME-$VER
TARGETBALL=$GNOMEDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	dbus-glib gnome-desktop Linux-PAM
. $WRK/_checkOptions.sh  \
	libgnomekbd
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i 's|etc/pam\.d"|etc"|' data/Makefile.in

Configuring
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --libexecdir=/usr/lib/gnome-screensaver \
            --with-pam-prefix=/etc \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

cat > /etc/pam.d/gnome-screensaver << "EOF"
# Begin /etc/pam.d/gnome-screensaver

auth     include        system-auth
auth     optional       pam_gnome_keyring.so

account  include        system-account
password include        system-password
session  include        system-session

# End /etc/pam.d/gnome-screensaver
EOF
chmod -v 644 /etc/pam.d/gnome-screensaver
paco -p+ $TARGET "\
touch /etc/pam.d/gnome-screensaver"

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

