#!/bin/sh

. ./_blfsset.sh

APPNAME=apache-ant
VER=1.9.6
JUNITVER=4.11
HAMCRESTVER=1.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/${TARGET}-src.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh openjdk
. $WRK/_checkOptions.sh  junit
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

tar -xvf $DLD/hamcrest-$HAMCRESTVER.tgz \
	> /dev/null || (echo tgz error && exit 1)

cp -v $DLD/junit-$JUNITVER.jar \
      hamcrest-$HAMCRESTVER/hamcrest-core-$HAMCRESTVER.jar lib/optional

porg -lp $TARGET "\
./build.sh -Ddist.dir=/opt/ant-$VER dist &&
ln -v -sfn ant-$VER /opt/ant" \
	1> $LOG/$TARGET.1_build.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

