#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

APPNAME=webkitgtk
#VER=1.10.2
VER=1.11.5
TARGET=$APPNAME-$VER
TARGETBALL=$XORGDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

unset MAKEFLAGS

echo $TARGET

. $WRK/_checkRequired.sh \
	gperf icu libxslt gtk+-3 ruby \
        libsoup geoclue which sqlite \
        gst-plugins-base-1 libwebp
. $WRK/_checkOptions.sh  curl enchant gtk-doc mathml
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

if [ ${OPTION_gtkdoc} -ne 1 ]; then
  sed -i '/generate-gtkdoc --rebase/s:^:# :' GNUmakefile.in
fi

#echo \ \ Patching unofficial...
#patch -Np1 -i $WRK/patch/webkitgtk-$VER.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1
#autoreconf -fi

Configuring
./configure --prefix=/usr \
            --libexecdir=/usr/lib/WebKitGTK \
            --with-gstreamer=1.0 \
            --enable-introspection \
            --with-gtk=3.0 \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

