#/bin/sh

CHAP=6
APPNAME=readline
VER=6.3
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Patching...
patch -Np1 -i $DLD/readline-$VER-upstream_fixes-3.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

sed -i '/MV.*old/d' Makefile.in
sed -i '/{OLDSUFF}/c:' support/shlib-install

echo \ \ Configuring...
./configure --prefix=/usr --docdir=/usr/share/doc/readline-$VER \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make SHLIB_LIBS=-lncurses \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET "make SHLIB_LIBS=-lncurses install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
mv -v /usr/lib/lib{readline,history}.so.* /lib" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -sfv ../../lib/$(readlink /usr/lib/libreadline.so) /usr/lib/libreadline.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -sfv ../../lib/$(readlink /usr/lib/libhistory.so ) /usr/lib/libhistory.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install -v -m644 doc/*.{ps,pdf,html,dvi} /usr/share/doc/readline-$VER" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || echo Error occured while copying

TimeEnd chap6

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

