#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=182
TARGET=udev-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
PKG_CONFIG_PATH=${PKG_CONFIG_PATH32} CC="gcc ${BUILD32}" \
  ./configure --prefix=/usr --sysconfdir=/etc --with-rootprefix="" \
  --libexecdir=/lib --bindir=/sbin \
  --with-usb-ids-path=no --with-pci-ids-path=no \
  --enable-rule_generator --disable-introspection --disable-keymap \
  --disable-gudev \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

